/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package gov.vha.vuid.rest.session;

import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.hk2.api.Rank;
import org.jvnet.hk2.annotations.Service;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import gov.vha.isaac.ochre.api.User;
import gov.vha.isaac.ochre.api.UserRole;

/**
 * The Class PrismeIntegratedUserService
 *
 * {@link PrismeIntegratedUserService}
 * 
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 */
@Service(name="rest-prismeUserService")
@Rank(value = 10)
@Singleton
public class PrismeIntegratedUserService implements PrismeUserService {
	private static Logger log = LogManager.getLogger(PrismeIntegratedUserService.class);
	
	//private Properties prismeProperties_ = null;

	protected PrismeIntegratedUserService() {
		//for HK2
	}

	/**
	 * 
	 * @see gov.vha.vuid.rest.session.PrismeUserService#getUser(java.lang.String)
	 */
	@Override
	public Optional<User> getUser(String ssoToken) {
		try {
			return Optional.of(getUserFromPrisme(ssoToken));
		} catch (Exception e) {
			log.error("Failed to retreive user from prisme with ssoToken '" + ssoToken + "'", e);
			return Optional.empty();
		}
	}

	/**
	 * @see gov.vha.isaac.ochre.api.UserRoleService#getUserRoles(java.util.UUID)
	 */
	@Override
	public Set<UserRole> getUserRoles(UUID userId)
	{
		throw new UnsupportedOperationException();
	}

	// Private helpers
	protected User getUserFromPrisme(String ssoToken) throws JsonParseException, JsonMappingException, IOException {
//		/*
//		 * Example URL for get_roles_by_token
//		 * URL url = new URL("https://DNS                     /?token=" + token);
//		 */
//		/*
//		 * Example SSO Token
//		 * %5B%22u%5Cf%5Cx8F%5CxB1X%5C%22%5CxC2%5CxEE%5CxFA%5CxE1%5Cx94%5CxBF3%5CxA9%5Cx16K%22%2C+%22%7EK%5CxC4%5CxEFXk%5Cx80%5CxB1%5CxA3%5CxF3%5Cx8D%5CxB1%5Cx7F%5CxBC%5Cx02K%22%2C+%22k%5Cf%5CxDC%5CxF7%2CP%5CxB2%5Cx97%5Cx99%5Cx99%5CxE0%5CxE1%7C%5CxBF%5Cx1DK%22%2C+%22J%5Cf%5Cx9B%5CxD8w%5Cx15%5CxFE%5CxD3%5CxC7%5CxDC%5CxAC%5Cx9E%5Cx1C%5CxD0bG%22%5D
//		 */
//		//String json = "{\"roles\":[{\"id\":10000,\"name\":\"read_only\",\"resource_id\":null,\"resource_type\":null,\"created_at\":\"2016-09-13T14:48:18.000Z\",\"updated_at\":\"2016-09-13T14:48:18.000Z\"}],\"token_parsed?\":true,\"user\":\"DNS   ",\"type\":\"ssoi\",\"id\":10005}";
		String prismeRolesByTokenUrlStr = PrismeServiceUtils.getConfigProperty("prisme_roles_by_token_url");
		URL url = new URL(prismeRolesByTokenUrlStr);
		User user = UserServiceUtils.getUserFromUrl(url, ssoToken);
		log.trace("Retrieved from " + prismeRolesByTokenUrlStr + " user=\"" + user + "\"");
		return user;
	}

	/**
	 * @see gov.vha.isaac.ochre.api.UserRoleService#getAllUserRoles()
	 */
	@Override
	public Set<UserRole> getAllUserRoles()
	{
		throw new UnsupportedOperationException();
	}
}
